ORCA/M Asm65816 2.1.0

0001 7F62
0002 7F62              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0003 7F62              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 5:28:9 PM
0004 7F62
0005 7F62
0006 7F62              ***********************************************
0007 7F62              *                                             *
0008 7F62              *  ADB Keyuc Code for Reset and Control Panel *
0009 7F62              *                                             *
0010 7F62              *                  by                         *
0011 7F62              *           Peter & Fern     1985-1987        *
0012 7F62              *           Joe Bo           1987-1989        *
0013 7F62              *                                             *
0014 7F62              *  Copyright Apple Computer, Inc. 1985-1989   *
0015 7F62              *           All Rights Reserved.              *
0016 7F62              *                                             *
0017 7F62              *                                             *
0018 7F62              ***********************************************
0019 7F62
0020 7F62
0021 7F62              * Entry Points:
0022 7F62              * RESETFDB ---> During RESET
0023 7F62              * PANELFDB ---> On exit from Control Panel
0024 7F62              *
0025 7F62              * ASSUMES 8-BIT M,X
0026 7F62              *
0027 7F62              * During RESET the SYNCH command is called to initialize the uC.
0028 7F62              * By clearing the data latch while sending the SYNCH command any
0029 7F62              * pending command or status will be cleared. Since this occurs during
0030 7F62              * a RESET this data doesn't have to be preserved.
0031 7F62              * If called from the Control Panel then any pending command or status
0032 7F62              * should be preserved. This can be accomplished by starting
0033 7F62              * with an abort call. Any pending command is completed
0034 7F62              * first. (Abort call is faked by jumping directly to tool set
0035 7F62              * entry point instead of using tool locator which may not exist yet).
0036 7F62              * After ABORT command then assumes no more pending commands.
0037 7F62              * If called during RESET then SYNCH command is implemented following
0038 7F62              * ABORT command. After the SYNCH command the pending and response
0039 7F62              * flags are cleared.
0040 7F62
0041 7F62
0042 7F62                       LONGA OFF
0043 7F62              RESETFDB EQU   *                        ;ENTRY POINT FOR RESET
0044 7F62 C2 10                 REP   #$10                     ;8 'm' with 16 bit 'x'
0045 7F64                       LONGI ON
0046 7F64 A2 70 17              LDX   #6000                    ;TIMEOUT ~30MS.
0047 7F67
0048 7F67 CA           @1       DEX                            ;CLEAR DATA REG. UNTIL CMD REG. IS FREE
0049 7F68 F0 09                 BEQ   @2
0050 7F6A AD 26 C0              LDA   |DATAREG                 ;Read and ignore anything pending
0051 7F6D AD 27 C0              LDA   |KMSTATUS
0052 7F70 6A                    ROR   A
0053 7F71 B0 F4                 BCS   @1                       ;DATA REG STILL FULL
0054 7F73
0055 7F73              @2       EQU   *
0056 7F73 A9 07                 LDA   #$07                     ;Synch command to keyuc
0057 7F75 20 72 81              JSR   CMDSEND                  ;Send it
0058 7F78 AD 26 C0              LDA   |DATAREG                 ;Clear out data reg in case previous cmd return data
0059 7F7B
0060 7F7B 20 F9 80     @4       JSR   SETUPMODE                ;SEND MODE BYTE
0061 7F7E 20 10 81              JSR   SETUPCNFG                ;SEND CONFIGURATION BYTES, NOT TRUE ONE !!
0062 7F81 20 44 81              JSR   SETKBDMSE                ;CONTINUE TO SEND KBD MOUSE PARAM
0063 7F84 20 63 81              JSR   SETDISKEJ                ;CONTINUE TO SEND DISKS EJECT OPTIONS
0064 7F87
0065 7F87 9C D7 0F     @3       STZ   |STATUSTMP               ;Clear characters pending flags
0066 7F8A 9C D6 0F              STZ   |FLAGS
0067 7F8D
0068 7F8D
0069 7F8D              * Allow a wait state for the key micro to set the buttons
0070 7F8D              * properly or we could drop into diagnostics unexpectedly.
0071 7F8D              *
0072 7F8D              * IMPORTANT:  DON'T CHANGE THE DELAY HERE !!!
0073 7F8D              *
0074 7F8D              * If the delay is changed, then the delay in the KEYUC needs 
0075 7F8D              * to be changed also so that it would match with each other  
0076 7F8D              * for STICKY to work right when invoking diagnostic or warm/
0077 7F8D              * cold start.
0078 7F8D
0079 7F8D A9 FF                 LDA   #$FF                     ;Huge wait time of over .162 seconds
0080 7F8F 20 A8 FC              JSR   WAIT                     ;Call twice in a row                  
0081 7F92
0082 7F92
0083 7F92 AD 61 C0              LDA   BUTN0                    ;GET OPEN APPLE KEY AT THIS POINT
0084 7F95 8D 40 01              STA   |EXTENDBNK               ;SAVE FOR LATER
0085 7F98 2A                    ROL   A                        ;SAVE IN CARRY
0086 7F99 AD 62 C0              LDA   BUTN1                    ;GET
0087 7F9C 8D 41 01              STA   |EXTENDBNK+1
0088 7F9F
0089 7F9F 10 0B                 BPL   @6                       ;IF EITHER BUTTON UP THEN
0090 7FA1 90 09                 BCC   @6                       ;SKIP AROUND DIAGNOSTICS
0091 7FA3              @5       EQU   *
0092 7FA3 E2 30                 SEP   #$30                     ;8 bit land a must
0093 7FA5 20 2E 9C              JSR   RAMVCTRS2                ;Setup bank $e1 vectors
0094 7FA8 5C 00 64 FF           JMP   >DIAGS                   ;BOTH BUTTONS PRESSED DO DIAGNOSTICS
0095 7FAC
0096 7FAC              @6       EQU   *
0097 7FAC AD 46 C0              LDA   DIAGTYPE                 ;MSB SET IF BURN IN DIAGNOSTICS
0098 7FAF 30 F2                 BMI   @5                       ;JUMP TO DIAGNOSTICS
0099 7FB1
0100 7FB1 AD 40 01              LDA   |EXTENDBNK               ;Test if power up requested by user or not
0101 7FB4 0D 41 01              ORA   |EXTENDBNK+1             ;
0102 7FB7 10 13                 BPL   @7                       ;Bra if both Apple keys are not pressed
0103 7FB9 A9 00                 LDA   #$00                     ;Else need to reset system power bytes
0104 7FBB 8F F4 03 00           STA   >PWREDUP                 ;Reset system powerup bytes
0105 7FBF 8F F3 03 00           STA   >SOFTEV+1                ;
0106 7FC3
0107 7FC3 AD 25 C0              LDA   |KEYMODREG               ;CHK if SHIFT pressed also
0108 7FC6 6A                    ROR   A                        ;STORE TO CARRY 
0109 7FC7 90 03                 BCC   @7                       ;BRA IF SHIFT KEY NOT PRESSED
0110 7FC9 9C FF 15              STZ   |RAMDSKPWRUP             ;Force true coldstart, init memory manager
0111 7FCC
0112 7FCC              @7       EQU   *
0113 7FCC
0114 7FCC A9 73                 LDA   #$73                     ;Disable mouse SRQ, fix bug in rev2 keyuc
0115 7FCE 20 72 81              JSR   CMDSEND                  ;Send command
0116 7FD1
0117 7FD1              * Now test system for powerup coldstart and
0118 7FD1              * set flags/system powerup bytes/RAM disk powerup
0119 7FD1              * bytes accordingly.
0120 7FD1
0121 7FD1 C2 30                 REP   #$30                     ;16 bit land a must
0122 7FD3                       LONGA ON
0123 7FD3 A9 BA FF              LDA   #>SECRTL                 ;Set up vectors just in case
0124 7FD6 8D 4E 00              STA   |IRQ_FLUSH+2             ;
0125 7FD9 8D 52 00              STA   |IRQ_MICRO+2             ;
0126 7FDC A9 5C 18              LDA   #SECRTL*256+$5C          ;Low byte and JMP abslong
0127 7FDF 8D 4C 00              STA   |IRQ_FLUSH+0             ;
0128 7FE2 8D 50 00              STA   |IRQ_MICRO+0             ;
0129 7FE5                       LONGA OFF
0130 7FE5 E2 20                 SEP   #$20                     ;
0131 7FE7
0132 7FE7 A9 0D                 LDA   #$0D                     ;Read keyuc version# command
0133 7FE9 20 72 81              JSR   CMDSEND                  ;Send it
0134 7FEC 20 96 81              JSR   RCVDATA                  ;Receive the returned ver#
0135 7FEF 8D 8E 01              STA   |KEYUCVER                ;Store for later
0136 7FF2 C9 06                 CMP   #$06                     ;>= $06 for Gyro or newer machine
0137 7FF4 90 29                 BCC   @8                       ;BRA for old gs
0138 7FF6 2C 36 C0              BIT   CYAREG                   ;Check power up bit, bit6
0139 7FF9 50 62                 BVC   @10                      ;BRA if already power up
0140 7FFB
0141 7FFB 9C A5 01              STZ   |GSC                     ;Bit7=1, GSc
0142 7FFE A9 09                 LDA   #$09                     ;Read keyuc memory command
0143 8000 20 72 81              JSR   CMDSEND                  ;
0144 8003 A9 E8                 LDA   #$E8                     ;Port3 of keyuc chip
0145 8005 20 72 81              JSR   SENDDATA                 ;
0146 8008 A9 00                 LDA   #$00                     ;Forming $00E8
0147 800A 20 72 81              JSR   SENDDATA                 ;
0148 800D 20 96 81              JSR   RCVDATA                  ;Read in keyuc port3 data
0149 8010 29 C0                 AND   #$C0                     ;Only bit7/6 are needed
0150 8012 8D A5 01              STA   |GSC                     ;
0151 8015
0152 8015 A9 40                 LDA   #$40                     ;Else reset power up bit for next time
0153 8017 8D B1 01              STA   |CYAVER                  ;Set $40 for CYA chip
0154 801A 1C 36 C0              TRB   CYAREG                   ;Reset bit6=0 to show already power up
0155 801D 80 2E                 BRA   @9                       ;Continue on
0156 801F
0157 801F              @8       EQU   *
0158 801F 9C B1 01              STZ   |CYAVER                  ;Set $00 for FPI chip
0159 8022 9C A5 01              STZ   |GSC                     ;Always set to $00 if old gs machine
0160 8025 A9 09                 LDA   #$09                     ;Read keyuc memory command
0161 8027 20 72 81              JSR   CMDSEND                  ;Send it
0162 802A A9 51                 LDA   #$51                     ;Low byte of memory loc      
0163 802C 20 72 81              JSR   SENDDATA                 ;
0164 802F A9 00                 LDA   #$00                     ;High byte of $0051
0165 8031 20 72 81              JSR   SENDDATA                 ;
0166 8034 20 96 81              JSR   RCVDATA                  ;Read power up byte from keyuc at loc $51
0167 8037 8D 68 01              STA   |RDMEMDATA               ;Store what was read
0168 803A C9 A5                 CMP   #MICROPOWER              ;Is it = to power up byte?
0169 803C F0 1F                 BEQ   @10                      ;If = then let RAM disk alone
0170 803E
0171 803E              * If here then the system was first time power up.
0172 803E              * We must now set up KEYUC LOCATION ($51) in keyuc
0173 803E              * to indicate this fact.
0174 803E
0175 803E A9 08                 LDA   #$08                     ;Write to keyuc memory loaction cmd
0176 8040 20 72 81              JSR   CMDSEND                  ;Send it
0177 8043 A9 51                 LDA   #$51                     ;keyuc page0 location to write to
0178 8045 20 72 81              JSR   SENDDATA                 ;Send it
0179 8048 A9 A5                 LDA   #$A5                     ;Send powerup byte to keyuc at $51
0180 804A 20 72 81              JSR   SENDDATA                 ;Send it
0181 804D
0182 804D
0183 804D              @9       EQU   *
0184 804D 9C FF 15              STZ   |RAMDSKPWRUP             ;Let RAM disk know it's power up
0185 8050 9C A6 01              STZ   |CLRHOLES                ;
0186 8053 A9 00                 LDA   #$00                     ;Zero out SOFTEV and PWREDUP
0187 8055 8F F3 03 00           STA   >SOFTEV+1
0188 8059 8F F4 03 00           STA   >PWREDUP
0189 805D
0190 805D              * Since the key repeat rate format for the current gs keyuc and
0191 805D              * the new keyuc is just opposite and also two more steps in the 
0192 805D              * new keyuc, therefore it is necessary to send out the configurations
0193 805D              * one more time here after the keyuc version has been read in.
0194 805D              * It is checked and adjusted in the SETUPCNFG routine !!!
0195 805D
0196 805D              @10      EQU   *
0197 805D A9 06                 LDA   #$06                     ;Set up configuration command
0198 805F 20 72 81              JSR   CMDSEND                  ;Send it
0199 8062 20 10 81              JSR   SETUPCNFG                ;Send real configurations for keyuc
0200 8065
0201 8065
0202 8065              * The following routines (READ LAYOUTS & CHAR SETS) are modified
0203 8065              * to reduce the traffic between the KEYUC for the sake of $0911
0204 8065              * error.  It is assumed that MEGA II  chip only supports eight
0205 8065              * countries character sets in current gs.
0206 8065
0207 8065
0208 8065              @100     EQU   *
0209 8065 A0 00 00              LDY   #$0000                   ;Index to batteryram buffer
0210 8068 A9 0A                 LDA   #$0A                     ;Keyboard layout counts
0211 806A 99 07 03     @101     STA   |LAYOUTS,Y               ;Store to buffer
0212 806D 98                    TYA                            ;Prepare for next store
0213 806E CD 07 03              CMP   |LAYOUTS                 ;check for end
0214 8071 C8                    INY                            ;Index to next
0215 8072 90 F6                 BCC   @101                     ;loop till end
0216 8074
0217 8074 A0 00 00              LDY   #$0000                   ;Set index for char sets buffer
0218 8077 A9 08                 LDA   #$08                     ;Character sets counts
0219 8079 99 FE 02     @102     STA   |LANGS,Y                 ;Store to buffer (1st = count)   
0220 807C 98                    TYA                            ;Prepare for next store
0221 807D CD FE 02              CMP   |LANGS                   ;Check for end
0222 8080 C8                    INY                            ;Index to next
0223 8081 90 F6                 BCC   @102                     ;Loop till end
0224 8083
0225 8083
0226 8083              * Enter here if only using control panel:
0227 8083              * Before sending the necessary commands and data to the keyuc
0228 8083              * It needs to make an abort call to the ADB tool so that any
0229 8083              * pending command can be handled first by the ADB tool then
0230 8083              * the Abort command can be send out.  It is quite often that
0231 8083              * an application is using ADB tool to talk to the ADB devices
0232 8083              * and at the mean time tries to get to the control panel, then 
0233 8083              * if an Abort is not made to the tool, it could occur that a 
0234 8083              * command is pending and blow up the communication between the 
0235 8083              * key micro.
0236 8083
0237 8083                                                      ; SEG $FF
0238 8083              PANELFDB EQU   *                        ;ENTRY POINT FOR CONTROL PANEL
0239 8083                                                      ; SEG $00	;Call must be made in 8 bit m/x
0240 8083 E2 30                 SEP   #$30                     ;Call must be made in 8 bit m/x
0241 8085                       LONGA OFF
0242 8085                       LONGI OFF
0243 8085 A9 0F                 LDA   #$0F                     ;Retry counts
0244 8087              @0       EQU   *
0245 8087 48                    PHA                            ;Temp save it
0246 8088 20 E4 A6              JSR   PUSH6                    ;Push room for 3 words on stack
0247 808B                       LONGA ON
0248 808B                       LONGI ON
0249 808B F4 01 00              PEA   $0001                    ;ABORT command
0250 808E 4B                    PHK                            ;Dummy address
0251 808F 62 04 00              PER   @1-1                     ;Return address
0252 8092 22 14 00 FE           JSL   >ADBSENDTL               ;Direct ADB tool call for sending a cmd
0253 8096 6B                    RTL                            ;Removes 3 bytes from stk/go to next instr
0254 8097              *
0255 8097              @1       EQU   *
0256 8097 E2 30                 SEP   #$30                     ;8 bit m/x
0257 8099 90 07                 BCC   @3                       ;BRA if successful send
0258 809B 68                    PLA                            ;Get back retry counts
0259 809C 3A                    DEC   A                        ;
0260 809D 10 E8                 BPL   @0                       ;RETRY !!!!
0261 809F 4C B1 81              JMP   ADBERR                   ;Display $911 error
0262 80A2              @3       EQU   *
0263 80A2 C2 10                 REP   #$10                     ;8/16 BIT m/x
0264 80A4                       LONGA OFF
0265 80A4                       LONGI ON
0266 80A4 68                    PLA                            ;Clean stack
0267 80A5
0268 80A5 A9 B3                 LDA   #$B3                     ;LISTEN R3 ADRS 3 (MOUSE ID)
0269 80A7 20 72 81              JSR   CMDSEND                  ;SEND COMMAND
0270 80AA A9 03                 LDA   #$03                     ;SEND NEW HANDLER - ADDRESS 3
0271 80AC 20 72 81              JSR   SENDDATA                 ; & DISABLE SRQ
0272 80AF AD F9 02              LDA   |USERHMR                 ;GET MOUSE TICK RESOLUTION
0273 80B2 C9 02                 CMP   #$02                     ;>=2 then ask mouse to change resolution
0274 80B4 B0 04                 BCS   HISPEED                  ;Bra for high resolution 
0275 80B6 A9 01                 LDA   #$01                     ;Else set mouse handler ID=1, low res
0276 80B8 80 02                 BRA   SENDID
0277 80BA              HISPEED  EQU   *
0278 80BA A9 02                 LDA   #$02                     ;Mouse handler ID=2 for high resolution
0279 80BC              SENDID   EQU   *
0280 80BC 20 72 81              JSR   SENDDATA                 ;SEND HANDLER 2 (LOW RES) OR 3 (HI RES)
0281 80BF
0282 80BF A9 05                 LDA   #$05                     ;CLEAR MODES
0283 80C1 20 72 81              JSR   CMDSEND
0284 80C4 A9 FF                 LDA   #$FF                     ;CLEARS ALL MODES
0285 80C6 20 72 81              JSR   SENDDATA
0286 80C9
0287 80C9 A9 04                 LDA   #$04                     ;SET MODES
0288 80CB 20 72 81              JSR   CMDSEND
0289 80CE 20 F9 80              JSR   SETUPMODE                ;GET MODE BYTE
0290 80D1
0291 80D1 A9 06                 LDA   #$06                     ;CONFIGURATION COMMAND
0292 80D3 20 72 81              JSR   CMDSEND
0293 80D6 20 10 81              JSR   SETUPCNFG                ;GET CONFIGURATION BYTES
0294 80D9
0295 80D9 AD 8E 01              LDA   |KEYUCVER                ;Get keyuc version#
0296 80DC C9 06                 CMP   #$06                     ;
0297 80DE 90 10                 BCC   @1                       ;BRA for //gs
0298 80E0 A9 12                 LDA   #$12                     ;SET KEYBOARD MOUSE PARAMETERS CMD
0299 80E2 20 72 81              JSR   SENDDATA                 ;AND SEND IT
0300 80E5 20 44 81              JSR   SETKBDMSE                ;GET INIT STEP, MAX SPEED AND ACC RATE
0301 80E8
0302 80E8 A9 13                 LDA   #$13                     ;Send disk1/2 eject option keys
0303 80EA 20 72 81              JSR   CMDSEND                  ;Send command byte first
0304 80ED 20 63 81              JSR   SETDISKEJ
0305 80F0
0306 80F0 9C D7 0F     @1       STZ   |STATUSTMP               ;Clear characters pending flags
0307 80F3 9C D6 0F              STZ   |FLAGS
0308 80F6
0309 80F6 E2 30                 SEP   #$30
0310 80F8
0311 80F8              RETSEC   EQU   *
0312 80F8 60                    RTS   
0313 80F9              * <END HERE>
0314 80F9
0315 80F9              * Subroutine used to set up mode byte
0316 80F9
0317 80F9              SETUPMODE EQU   *
0318 80F9 A9 00                 LDA   #0                       ;BUILD NEW MODES
0319 80FB 0D EF 02              ORA   |USERCAPS                ;XOR CAPS LOCK
0320 80FE 0A                    ASL   A
0321 80FF 0A                    ASL   A
0322 8100 0D EB 02              ORA   |USERKBUFF               ;KEYBOARD BUFFERING
0323 8103 0A                    ASL   A
0324 8104 0D F1 02              ORA   |USERDUAL                ;DUAL SPEED OPTION
0325 8107 0A                    ASL   A
0326 8108 0D F0 02              ORA   |USERFSPDE               ;INCLUDE SPACE, DELETE ON DUAL
0327 810B 0A                    ASL   A
0328 810C 0A                    ASL   A
0329 810D 4C 72 81              JMP   SENDDATA                 ;AND SEND IT
0330 8110
0331 8110 A9 32        SETUPCNFG LDA   #$32                    ;BUILD CONFIGURATION DATA
0332 8112 20 6F 81              JSR   SENDDATA0                ;If error, need to clean 6 bytes for stack
0333 8115 AD E9 02              LDA   |USERDISP                ;CHARACTER SET
0334 8118 0A                    ASL   A
0335 8119 0A                    ASL   A
0336 811A 0A                    ASL   A
0337 811B 0A                    ASL   A
0338 811C 0D EA 02              ORA   |USERLANG                ;LAYOUT
0339 811F 20 6F 81              JSR   SENDDATA0
0340 8122 AD ED 02              LDA   |USERRDLY                ;DELAY TO REPEAT
0341 8125 0A                    ASL   A
0342 8126 0A                    ASL   A
0343 8127 0A                    ASL   A
0344 8128 0A                    ASL   A
0345 8129 48                    PHA                            ;Save 'A'
0346 812A AD 8E 01              LDA   |KEYUCVER                ;Get keyuc version#
0347 812D C9 06                 CMP   #$06                     ;Set 'c', >=$06 then new keyuc
0348 812F AD EC 02              LDA   |USERRSPD                ;Pre-load auto repeat rate
0349 8132 B0 08                 BCS   @1                       ;BRA if new keyuc in the system
0350 8134 C9 08                 CMP   #$08                     ;Else need to check the value
0351 8136 90 02                 BCC   @2                       ;BRA if not > 8, old one accepts 0-7 only
0352 8138 A9 07                 LDA   #$07                     ;If 8, 9 then force to 7
0353 813A 49 07        @2       EOR   #$07                     ;Flip low 3 bits for old keyuc
0354 813C              @1       EQU   *
0355 813C 03 01                 ORA   1,S                      ;Combine with delay to repeat
0356 813E 83 01                 STA   1,S                      ;Store back to stack
0357 8140 68                    PLA                            ;Get back and clean stack
0358 8141 4C 72 81              JMP   SENDDATA
0359 8144
0360 8144              SETKBDMSE EQU   *
0361 8144 AD FB 02              LDA   |USERMDLY                ;GET THE MOUSE DELAY-TO-START, 0-4
0362 8147 0A                    ASL   A                        ;SHIFT TO HIGH NIBBLES
0363 8148 0A                    ASL   A
0364 8149 0A                    ASL   A
0365 814A 0A                    ASL   A
0366 814B 0D F9 02              ORA   |USERHMR                 ;ADD IN MOUSE TRACKING, 0-4        
0367 814E 20 6F 81              JSR   SENDDATA0                ;AND SEND IT
0368 8151 AD FC 02              LDA   |USERSPRT                ;GET THE ACCELERATION, 0-4
0369 8154 0A                    ASL   A
0370 8155 0A                    ASL   A
0371 8156 0A                    ASL   A
0372 8157 0A                    ASL   A
0373 8158 0D FD 02              ORA   |USERMAXSP               ;ADD IN MAX SPEED TO LOW NIBBLES
0374 815B 49 70                 EOR   #$70                     ;Make accelration from 7-3
0375 815D 38                    SEC                            ;Be careful w/ this 'c'
0376 815E E9 30                 SBC   #$30                     ;Adjust acceleration to 4-0
0377 8160 4C 72 81              JMP   SENDDATA
0378 8163              SETDISKEJ EQU   *
0379 8163 AD F2 02              LDA   |USERD1EJ                ;Get internal disk1 ejection option key
0380 8166 20 6F 81              JSR   SENDDATA0                ;Send to keyuc
0381 8169 AD F3 02              LDA   |USERD2EJ                ;Get internal disk2 ejection option key
0382 816C 4C 72 81              JMP   SENDDATA                 ;Send to keyuc
0383 816F
0384 816F              SENDDATA0 EQU   *
0385 816F 38                    SEC                            ;Set as an indicator for error exit
0386 8170 80 01                 BRA   COMMSEND                 ;Continue on....
0387 8172              CMDSEND  EQU   *                        ;Send commands and data share
0388 8172              SENDDATA EQU   *                        ; same routine
0389 8172 18                    CLC                            ;An indicator to clean stack during exits
0390 8173              COMMSEND EQU   *
0391 8173                       LONGA OFF
0392 8173                       LONGI ON
0393 8173 08                    PHP                            ;Save 'c' and interrupt status
0394 8174 78                    SEI                            ;Disable interrrupt
0395 8175 AA                    TAX                            ;Save off command/data
0396 8176 A0 0A 00              LDY   #10                      ;Set re-try count to 10
0397 8179              TRYMORE  EQU   *
0398 8179 AD 27 C0              LDA   KMSTATUS                 ;Get command register full bit --> LSB
0399 817C 6A                    ROR   A                        ;Into carry bit
0400 817D 8A                    TXA                            ;Get data back
0401 817E B0 11                 BCS   NOTEMPTY0                ;BRA if register not empty, RE-TRY!!!
0402 8180 8D 26 C0              STA   CMDREG                   ;Else store away new command/data
0403 8183 A2 4C 1D              LDX   #7500                    ;TIMEOUT 7500*(2+2+4+2+3)/3 = 30 MS
0404 8186 CA           GOON0    DEX   
0405 8187 F0 22                 BEQ   TIMEOUTERR               ;Time out error
0406 8189 AD 27 C0              LDA   KMSTATUS                 ;Get command register full bit --> LSB
0407 818C 6A                    ROR   A                        ;Into carry bit
0408 818D B0 F7                 BCS   GOON0                    ;BRA if full, not yet read by keyuc
0409 818F 28                    PLP                            ;Restore 'c' and interrupt status
0410 8190 60                    RTS   
0411 8191
0412 8191              NOTEMPTY0 EQU   *
0413 8191 88                    DEY                            ;Try one more time
0414 8192 F0 17                 BEQ   NOTEMPTY                 ;Already re-try 10 times
0415 8194 80 E3                 BRA   TRYMORE                  ;BRA to try more
0416 8196
0417 8196              RCVDATA  EQU   *
0418 8196                       LONGA OFF
0419 8196                       LONGI ON
0420 8196 18                    CLC   
0421 8197 08                    PHP                            ;Save interrupt status
0422 8198 78                    SEI                            ;Disable interrupt
0423 8199 A2 EC 2C              LDX   #11500                   ;approx 50 ms
0424 819C CA           GOON1    DEX   
0425 819D F0 0C                 BEQ   TIMEOUTERR               ;Time out error for reading
0426 819F AD 27 C0              LDA   KMSTATUS                 ;Get data reg full bit, bit5
0427 81A2 29 20                 AND   #DATAFULL                ;Test for full
0428 81A4 F0 F6                 BEQ   GOON1                    ;Not set (empty), try more !!
0429 81A6 AD 26 C0              LDA   DATAREG                  ;If set then read in DATA
0430 81A9 28                    PLP                            ;Restore interrupt status
0431 81AA 60                    RTS   
0432 81AB
0433 81AB              NOTEMPTY EQU   *                        ;Error for system writes to keyuc
0434 81AB              TIMEOUTERR EQU   *                      ;Error for system <---> keyuc time out
0435 81AB 28                    PLP                            ;Restore 'c' and interrupt status
0436 81AC 90 01                 BCC   CLEAN4                   ;If 'C' = 0 then clean 4 bytes from stack
0437 81AE FA                    PLX                            ;Else clean 6 bytes
0438 81AF FA           CLEAN4   PLX                            ;16 bit 'x', clean up 4 bytes from stack
0439 81B0 FA                    PLX                            ;2 for local jsr, 2 for call to RESETFDB OR PANELFDB
0440 81B1              ADBERR   EQU   *
0441 81B1 E2 30                 SEP   #$30                     ;8 bit m/x a must
0442 81B3                       LONGA OFF
0443 81B3                       LONGI OFF
0444 81B3 20 2E 9C              JSR   RAMVCTRS2                ;Set up bank $e1 vectors first
0445 81B6 F4 11 09              PEA   ERRCODE                  ;Error code for tool
0446 81B9
0447 81B9              * Word 1/2 pointer to nowhere
0448 81B9              * Word 3 = create dummy RTL address
0449 81B9
0450 81B9 20 E4 A6              JSR   PUSH6                    ;Push room for 3 words on stack
0451 81BC 8B                    PHB   
0452 81BD 38                    SEC   
0453 81BE 5C 33 A5 FF           JMP   >SYSDEATH                ;System death, error synch with keyuc
0454 81C2
0455 81C2
